/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeProxy;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DOM2Helper {
    private DOM2Helper() {
    }

    public static String getLocalNameOfNode(Node node) {
        String string = node.getLocalName();
        return null == string ? DOM2Helper.getLocalNameOfNodeFallback(node) : string;
    }

    private static String getLocalNameOfNodeFallback(Node node) {
        String string = node.getNodeName();
        int n = string.indexOf(58);
        return n < 0 ? string : string.substring(n + 1);
    }

    public static String getNamespaceOfNode(Node node) {
        return node.getNamespaceURI();
    }

    public static boolean isNodeAfter(Node node, Node node2) {
        Node node3;
        if (node == node2 || DOM2Helper.isNodeTheSame(node, node2)) {
            return true;
        }
        boolean bl = true;
        Node node4 = DOM2Helper.getParentOfNode(node);
        if (node4 == (node3 = DOM2Helper.getParentOfNode(node2)) || DOM2Helper.isNodeTheSame(node4, node3)) {
            if (null != node4) {
                bl = DOM2Helper.isNodeAfterSibling(node4, node, node2);
            }
        } else {
            int n;
            int n2;
            int n3 = 2;
            int n4 = 2;
            while (node4 != null) {
                ++n3;
                node4 = DOM2Helper.getParentOfNode(node4);
            }
            while (node3 != null) {
                ++n4;
                node3 = DOM2Helper.getParentOfNode(node3);
            }
            Node node5 = node;
            Node node6 = node2;
            if (n3 < n4) {
                n2 = n4 - n3;
                for (n = 0; n < n2; ++n) {
                    node6 = DOM2Helper.getParentOfNode(node6);
                }
            } else if (n3 > n4) {
                n2 = n3 - n4;
                for (n = 0; n < n2; ++n) {
                    node5 = DOM2Helper.getParentOfNode(node5);
                }
            }
            Node node7 = null;
            Node node8 = null;
            while (null != node5) {
                if (node5 == node6 || DOM2Helper.isNodeTheSame(node5, node6)) {
                    if (null == node7) {
                        bl = n3 < n4;
                        break;
                    }
                    bl = DOM2Helper.isNodeAfterSibling(node5, node7, node8);
                    break;
                }
                node7 = node5;
                node5 = DOM2Helper.getParentOfNode(node5);
                node8 = node6;
                node6 = DOM2Helper.getParentOfNode(node6);
            }
        }
        return bl;
    }

    public static boolean isNodeTheSame(Node node, Node node2) {
        if (node instanceof DTMNodeProxy && node2 instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).equals((DTMNodeProxy)node2);
        }
        return node == node2;
    }

    public static Node getParentOfNode(Node node) {
        Node node2 = node.getParentNode();
        if (node2 == null && 2 == node.getNodeType()) {
            node2 = ((Attr)node).getOwnerElement();
        }
        return node2;
    }

    private static boolean isNodeAfterSibling(Node node, Node node2, Node node3) {
        boolean bl = false;
        short s = node2.getNodeType();
        short s2 = node3.getNodeType();
        if (2 != s && 2 == s2) {
            bl = false;
        } else if (2 == s && 2 != s2) {
            bl = true;
        } else if (2 == s) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < n; ++i) {
                Node node4 = namedNodeMap.item(i);
                if (node2 == node4 || DOM2Helper.isNodeTheSame(node2, node4)) {
                    if (bl3) {
                        bl = false;
                        break;
                    }
                    bl2 = true;
                    continue;
                }
                if (node3 != node4 && !DOM2Helper.isNodeTheSame(node3, node4)) continue;
                if (bl2) {
                    bl = true;
                    break;
                }
                bl3 = true;
            }
        } else {
            boolean bl4 = false;
            boolean bl5 = false;
            for (Node node5 = node.getFirstChild(); null != node5; node5 = node5.getNextSibling()) {
                if (node2 == node5 || DOM2Helper.isNodeTheSame(node2, node5)) {
                    if (bl5) {
                        bl = false;
                        break;
                    }
                    bl4 = true;
                    continue;
                }
                if (node3 != node5 && !DOM2Helper.isNodeTheSame(node3, node5)) continue;
                if (bl4) {
                    bl = true;
                    break;
                }
                bl5 = true;
            }
        }
        return bl;
    }
}

